﻿#include <iostream>
#include <string>
#include <conio.h>
using namespace std;

const int rows = 27;
const int columns = 90;
const string fg_blue = "\x1B[94m";
const string fg_white = "\033[0m";
const string fg_black = "\x1b[30m";
const string fg_red = "\x1b[31m";
const string bg_yellow = "\x1b[43m";
const string bg_black = "\x1b[40m";

class Game {
private:
	char map[rows][columns];
	double health;
	int apples_collected;
	int monsters_defeated;
	int player_row;
	int player_col;
	bool can_move(int target_row, int target_col) {
		if (map[target_row][target_col] == '#' or map[target_row][target_col] == 'T') {
			return false;
		}
		return true;
	}
	bool is_on_enemy() {
		if (map[player_row][player_col] == 'r' or map[player_row][player_col] == 's') {
			return true;
		}
		return false;
	}
	bool is_on_food() {
		if (map[player_row][player_col] == 'o') {
			return true;
		}
		return false;
	}
	void defeat_monster() {
		map[player_row][player_col] = '.';
		monsters_defeated++;
	}
	void eat_food() {
		map[player_row][player_col] = '.';
		apples_collected++;
	}
public:
	void initialize() {
		health = 100;
		apples_collected = 0;
		monsters_defeated = 0;
	}

	void generate(unsigned int seed) {
		srand(seed);

		// prepreke:	# (uz rub)
		// drvo:		T (5% šanse)
		// trava:		. (87% šanse)
		// igrač:		@ (dolje lijevo)
		// jabuka:		o (1% šanse)
		// štakor:		r (1% šanse)
		// pauk:		s (1% šanse)
		for (int r = 0; r < rows; r++) {
			for (int c = 0; c < columns; c++) {
				if (r == 0 or r == rows - 1 or c == 0 or c == columns - 1) { // rub
					map[r][c] = '#';
				}
				else if (r == rows - 2 and c == 1) { // igrač
					player_row = r;
					player_col = c;
					map[r][c] = '.'; // kad igrač ode, ostaje trava
				}
				else {
					int gn = 1 + rand() % 100;
					if (gn <= 1) { // jabuka
						map[r][c] = 'o';
					}
					else if (gn <= 2) { // štakor
						map[r][c] = 'r';
					}
					else if (gn <= 3) { // pauk
						map[r][c] = 's';
					}
					else if (gn <= 8) { // drvo
						map[r][c] = 'T';
					}
					else { // trava
						map[r][c] = '.';
					}
				}
			}
		}
	}
	void draw() {
		system("cls");
		cout << fg_blue << "HEALTH: " << fg_black << bg_yellow << health << fg_white << bg_black << "\t\t";
		cout << fg_blue << "MONSTERS: " << fg_black << bg_yellow << monsters_defeated << fg_white << bg_black << "\t\t";
		cout << fg_blue << "APPLES: " << fg_black << bg_yellow << apples_collected << fg_white << bg_black << "\t\t" << endl;

		for (int r = 0; r < rows; r++) {
			for (int c = 0; c < columns; c++) {
				if (r == player_row and c == player_col) {
					cout << '@';
				}
				else {
					cout << map[r][c];
				}
			}
			cout << endl;
		}
	}
	void move(char action) {
		if (action == 'a' and player_col - 1 >= 0 and can_move(player_row, player_col - 1)) {
			player_col--;
		}
		else if (action == 'd' and player_col + 1 < columns and can_move(player_row, player_col + 1)) {
			player_col++;
		}
		else if (action == 'w' and player_row - 1 >= 0 and can_move(player_row - 1, player_col)) {
			player_row--;
		}
		else if (action == 's' and player_row + 1 < rows and can_move(player_row + 1, player_col)) {
			player_row++;
		}
	}
	bool process() {
		if (is_on_enemy()) {
			health -= 12.5;
			if (health <= 0) {
				return false;
			}

			defeat_monster();
		}

		if (is_on_food()) {
			health += 15;
			if (health > 100) {
				health = 100;
			}

			eat_food();
		}

		return true;
	}
};

int main() {
	Game game;
	game.initialize();
	game.generate(42);
	game.draw();

	// game loop
	while (true) {
		char action = (char)_getch();
		if (action == (char)27) { // escape
			break;
		}

		game.move(action);
		if (!game.process()) {
			system("cls");
			cout << endl << endl << endl << endl;
			cout << fg_red << "\t\t\t\tGAME OVER" << fg_white << endl;
			cout << endl << endl << endl << endl;
			break;
		}

		game.draw();
	}
	return 0;
}
