package hr.algebra.menudialogspreferences

import android.app.DatePickerDialog
import android.content.Intent
import android.content.SharedPreferences
import android.os.Bundle
import android.view.Menu
import android.view.MenuItem
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import androidx.preference.PreferenceManager
import hr.algebra.menudialogspreferences.databinding.ActivityMainBinding
import java.util.Calendar
import androidx.core.content.edit
import java.util.Date

class MainActivity : AppCompatActivity() {


    private lateinit var binding: ActivityMainBinding

    private lateinit var preferences: SharedPreferences
    private lateinit var dateKey: String

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        initPreferences()
    }

    private fun initPreferences() {
        preferences = PreferenceManager.getDefaultSharedPreferences(this)
        dateKey = getString(R.string.date_key)
    }

    override fun onResume() {
        super.onResume()
        setDate()
    }
    override fun onCreateOptionsMenu(menu: Menu?): Boolean {
        menuInflater.inflate(R.menu.menu, menu)
        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        when(item.itemId) {
            R.id.miPreferences -> {
                showPreferences()
                return true
            }
            R.id.miCalendar -> {
                showCalendar()
                return true
            }
            R.id.miExit -> {
                exitApp()
                return true
            }
        }
        return super.onOptionsItemSelected(item)
    }

    private fun showPreferences() {
        startActivity(Intent(this, PreferenceActivity::class.java))
    }

    private fun showCalendar() {

        val date = Calendar.getInstance()
        if(preferences.contains(dateKey)) {
            date.timeInMillis = preferences.getLong(dateKey, -1)
        }

        val year = date.get(Calendar.YEAR)
        val month = date.get(Calendar.MONTH)
        val day = date.get(Calendar.DAY_OF_MONTH)

        DatePickerDialog(
            this,
            { _, y, m, d ->
                Calendar.getInstance().apply {
                    set(y, m, d)
                    preferences
                        .edit {
                            putLong(dateKey, timeInMillis)
                        }
                    setDate()
                }
            },
            year,
            month,
            day
        ).show()
    }

    private fun setDate() {
        if(preferences.contains(dateKey)) {
            val timeInMillis = preferences.getLong(dateKey, -1)
            with(Date(timeInMillis)) {
                val dateFormat = android.text.format.DateFormat.getDateFormat(this@MainActivity)
                binding.tvDate.text = dateFormat.format(this)
            }
        }
    }

    private fun exitApp() {
        AlertDialog.Builder(this).apply {
            setTitle(R.string.exit)
            setMessage(getString(R.string.really_exit_the_app))
            setIcon(R.drawable.exit)
            setCancelable(true)
            setPositiveButton("Ok") { _, _ -> finish() }
            setNegativeButton(getString(R.string.cancel), null)
            show()
        }
    }

}