package hr.algebra.bodymassindex

import android.os.Bundle
import android.widget.EditText
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import hr.algebra.bodymassindex.databinding.ActivityMainBinding
import hr.algebra.bodymassindex.utils.hideKeyboard
import kotlin.math.pow

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    private lateinit var validationFields: List<EditText>

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        initValidation()
        setupListeners()
    }

    private fun initValidation() {
        validationFields = listOf(binding.etWeight, binding.etHeight)
    }

    private fun setupListeners() {
        binding.btnCalculate.setOnClickListener {
            if (formValid()) {
                val bmi: Double? = calculateBmi(
                    binding.etWeight.text.toString().toDouble(),
                    binding.etHeight.text.toString().toDouble()
                )
                handleLayout(bmi)
                hideKeyboard()
            }
        }
    }

    private fun formValid(): Boolean {
        validationFields.forEach {
            if (it.text.toString().isBlank()) {
                it.error = getString(R.string.please_insert_value)
                it.requestFocus()
                return false
            }
        }
        return true
    }

    private fun calculateBmi(weight: Double, height: Double) =
        if (weight <= 0 || height <= 0) {
            null
        } else {
            val heightFinal = if (height > 3) height / 100 else height
            weight / heightFinal.pow(2)
        }

    private fun handleLayout(bmi: Double?) = when {
        bmi == null -> {
            binding.tvBmi.text = ""
            binding.ivBmi.setImageDrawable(null)
        }
        bmi <= 20 -> {
            binding.tvBmi.text = getString(R.string.underweight)
            binding.ivBmi.setImageResource(R.drawable.sad)
        }
        bmi <= 25 -> {
            binding.tvBmi.text = getString(R.string.normal)
            binding.ivBmi.setImageResource(R.drawable.happy)
        }
        else -> {
            binding.tvBmi.text = getString(R.string.overweight)
            binding.ivBmi.setImageResource(R.drawable.sad)
        }
    }
}