package hr.algebra.nasa.handler

import android.content.Context
import android.util.Log
import hr.algebra.nasa.factory.createGetHttpUrlConnection
import java.io.File
import java.net.HttpURLConnection
import java.nio.file.Files
import java.nio.file.Paths

private const val TAG = "IMAGES_HANDLER"

fun downloadImageAndStore(context: Context, url: String) : String? {
    val filename = url.substring(url.lastIndexOf(File.separatorChar) + 1)
    val file : File = createFile(context, filename)
    try {
        val con: HttpURLConnection = createGetHttpUrlConnection(url)
        Files.copy(con.inputStream, file.toPath()) // api 26 -> URI uppercase!
        return file.absolutePath
    } catch (e: Exception) {
        Log.e(TAG, e.message, e)
    }
    return null
}

private fun createFile(context: Context, filename: String): File {
    val dir = context.applicationContext.getExternalFilesDir(null)
    val file = File(dir, filename)
    if (file.exists()) {
        file.delete()
    }
    return file
}