package hr.algebra.intentspermissions

import android.content.Intent
import android.os.Bundle
import android.provider.ContactsContract
import android.text.Editable
import android.text.TextWatcher
import android.view.View
import androidx.activity.result.contract.ActivityResultContracts
import androidx.appcompat.app.AppCompatActivity
import hr.algebra.intentspermissions.databinding.ActivityMainBinding
import android.Manifest
import android.content.pm.PackageManager
import android.os.Build
import android.telephony.SmsManager
import androidx.core.app.ActivityCompat

private const val MIME_TYPE = "text/plain"
private const val SMS_REQ = 1

class MainActivity : AppCompatActivity() {
    private lateinit var binding: ActivityMainBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        toggleWidgets()
        setupListeners()
    }

    private fun toggleWidgets() {
        binding.ivSendSms.visibility =
            if (binding.etNumber.text.toString().isNotBlank() && binding.etMessage.text.toString().isNotBlank())
                View.VISIBLE
            else
                View.INVISIBLE
        binding.ivShare.visibility =
            if (binding.etMessage.text.toString().isNotBlank())
                View.VISIBLE
            else
                View.INVISIBLE
    }

    private fun setupListeners() {
        val textWatcher = object: TextWatcher {
            override fun beforeTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {
            }

            override fun onTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {
                toggleWidgets()
            }

            override fun afterTextChanged(p0: Editable?) {
            }
        }
        binding.etNumber.addTextChangedListener(textWatcher)
        binding.etMessage.addTextChangedListener(textWatcher)

        binding.ivPickContact.setOnClickListener { pickContact() }
        binding.ivSendSms.setOnClickListener { sendSms() }
        binding.ivShare.setOnClickListener { share() }
    }

    private val pickContact = registerForActivityResult(ActivityResultContracts.StartActivityForResult()) {
        if (it.resultCode == RESULT_OK) {
            val contactUri = it.data?.data!!
            val cursor = contentResolver.query(contactUri, null, null, null, null)
            if (cursor?.moveToFirst() == true) {
                val number =  cursor.getString(cursor.getColumnIndexOrThrow(ContactsContract.CommonDataKinds.Phone.NUMBER))
                binding.etNumber.setText(number)
            }
        }
    }

    private fun pickContact() {
        Intent(Intent.ACTION_PICK, ContactsContract.CommonDataKinds.Phone.CONTENT_URI).apply {
            pickContact.launch(this)
        }
    }

    private fun sendSms() {

        if (ActivityCompat.checkSelfPermission(this, Manifest.permission.SEND_SMS) != PackageManager.PERMISSION_GRANTED) {
            ActivityCompat.requestPermissions(
                this,
                arrayOf(Manifest.permission.SEND_SMS),
                SMS_REQ
            )
            return
        }
        @Suppress("DEPRECATION") val smsManager =
            if(Build.VERSION.SDK_INT >= Build.VERSION_CODES.S)
                getSystemService(SmsManager::class.java)
            else
                SmsManager.getDefault()

        smsManager.sendTextMessage(
            binding.etNumber.text.toString(),
            null,
            binding.etMessage.text.toString(),
            null,
            null
        )
    }

    private fun share() {
        Intent(Intent.ACTION_SEND).apply {
            type = MIME_TYPE
            putExtra(Intent.EXTRA_TEXT, binding.etMessage.text.toString())
        }.also {
            startActivity(Intent.createChooser(it, getString(R.string.share_message)))
        }
    }

    override fun onRequestPermissionsResult(
        requestCode: Int,
        permissions: Array<out String>,
        grantResults: IntArray
    ) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
        if (grantResults.isNotEmpty() && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            when (requestCode) {
                SMS_REQ -> sendSms()
            }
        }
    }
}