package hr.algebra.questionairre

import android.os.Bundle
import android.text.Editable
import android.text.TextWatcher
import android.view.View
import android.widget.Toast
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import hr.algebra.questionairre.databinding.ActivityMainBinding
import hr.algebra.questionairre.model.Question
import hr.algebra.questionairre.model.utils.showToast
import hr.algebra.questionairre.repository.QuestionRepository

private const val QUESTION_INDEX = "hr.algebra.questionnaire.question_index"
class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    private var questionIndex = 0
    private var question: Question? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        setupListeners()
    }

    private fun setupListeners() {
        binding.etAnswer.addTextChangedListener(object : TextWatcher {
            override fun afterTextChanged(p0: Editable?) {
            }

            override fun beforeTextChanged(
                p0: CharSequence?,
                p1: Int,
                p2: Int,
                p3: Int,
            ) {
            }

            override fun onTextChanged(
                text: CharSequence?,
                p1: Int,
                p2: Int,
                p3: Int,
            ) {
                binding.btnNext.isEnabled = text?.isNotBlank() ?: false
            }
        })
        binding.btnNext.setOnClickListener {
            if (question!!.isCorrect(binding.etAnswer.text.toString().trim())) {
                showToast(getString(R.string.correct))
            } else {
                showToast(getString(R.string.incorrect))
            }
            refresh()
        }
    }

    private fun refresh() {
        binding.etAnswer.text.clear()
        questionIndex++
        setCurrentQuestion()
    }

    override fun onResume() {
        super.onResume()
        setCurrentQuestion()
    }

    private fun setCurrentQuestion() {
        question = QuestionRepository[questionIndex]
        if (question != null) {
            binding.tvQuestion.text = question.toString()
        } else {
            binding.tvQuestion.text = getString(R.string.thank_you)
            setWidgetsVisibility(View.INVISIBLE)
        }
    }

    private fun setWidgetsVisibility(visibility: Int) {
        binding.btnNext.visibility = visibility
        binding.etAnswer.visibility = visibility
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        outState.putInt(QUESTION_INDEX, questionIndex)
    }

    override fun onRestoreInstanceState(savedInstanceState: Bundle) {
        super.onRestoreInstanceState(savedInstanceState)
        questionIndex = savedInstanceState.getInt(QUESTION_INDEX)
    }
}