package hr.algebra.todo.model

private const val DEL = "|"

data class Item(val text: String, var done: Boolean = false) {

    fun format() = "${text}${DEL}${done}\n"

    companion object {
        fun parse(line: String) = line
            .split(DEL)
            .let {
                Item(it[0], it[1].toBoolean())
            }
    }
}
