package hr.algebra.todo

import android.os.Bundle
import android.text.Editable
import android.text.TextWatcher
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.LinearLayoutManager
import hr.algebra.todo.adapter.ItemAdapter
import hr.algebra.todo.databinding.ActivityMainBinding
import hr.algebra.todo.model.Item
import hr.algebra.todo.model.ItemList

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding

    private lateinit var itemList: ItemList
    private lateinit var itemAdapter: ItemAdapter

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityMainBinding.inflate(layoutInflater)
        setContentView(binding.root)

        setAdapter()
        setupListener()
    }

    private fun setAdapter() {
        itemList = ItemList(this)
        itemAdapter = ItemAdapter(itemList)
        binding.rvItems.apply {
            layoutManager = LinearLayoutManager(this@MainActivity)
            adapter = itemAdapter
        }
    }

    private fun setupListener() {
        binding.etItem.addTextChangedListener(object: TextWatcher {
            override fun afterTextChanged(p0: Editable?) {

            }

            override fun beforeTextChanged(
                p0: CharSequence?,
                p1: Int,
                p2: Int,
                p3: Int,
            ) {
            }

            override fun onTextChanged(
                text: CharSequence?,
                p1: Int,
                p2: Int,
                p3: Int,
            ) {
                if(text?.endsWith(System.lineSeparator()) == true) {
                    addItem()
                }
            }
        })

        binding.btnAdd.setOnClickListener {
            addItem()
        }
    }
    private fun addItem() {
        if(binding.etItem.text.toString().isNotBlank()) {
            itemList.add(Item(binding.etItem.text.toString().trim()))
            itemAdapter.notifyItemInserted(itemList.size - 1)
            binding.etItem.text.clear()
        }
    }

    override fun onPause() {
        super.onPause()
        itemList.saveInFile()
    }

    override fun onResume() {
        super.onResume()
        itemList.isEmpty().let {
            itemList.loadFromFile()
        }
    }
}