package hr.algebra.nasa.api

import android.content.Context
import android.util.Log
import hr.algebra.nasa.NasaReceiver
import hr.algebra.nasa.framework.sendBroadcast
import hr.algebra.nasa.handler.downloadImageAndStore
import hr.algebra.nasa.model.Item
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.create

class NasaFetcher(private val context: Context) {

    private var nasaApi: NasaApi
    init {
        val retrofit = Retrofit.Builder()
            .baseUrl(API_URL)
            .addConverterFactory(GsonConverterFactory.create())
            .build()
        //nasaApi = retrofit.create(NasaApi::class.java)
        nasaApi = retrofit.create<NasaApi>()
    }
    fun fetchItems(count: Int = 10) {
        val request = nasaApi.fetchItems(count)

        request.enqueue(object : Callback<List<NasaItem>> {
            override fun onFailure(call: Call<List<NasaItem>>, t: Throwable) {
                Log.d(javaClass.name, t.message, t)
            }

            override fun onResponse(
                call: Call<List<NasaItem>>,
                response: Response<List<NasaItem>>
            ) {
                // response returns in the foreground
                response.body()?.let { populateItems(it) }
            }

        })

    }

    private fun populateItems(nasaItems: List<NasaItem>) {
        val items = mutableListOf<Item>()
        // we must go in background to download images
        val scope = CoroutineScope(Dispatchers.IO)
        scope.launch {
            nasaItems.forEach {
                val picturePath = downloadImageAndStore(context, it.url)
                items.add(Item(null, it.title, it.explanation, picturePath ?: "", it.date, false))
            }
            context.sendBroadcast<NasaReceiver>() // must be in scope!!!
        }
    }

}