﻿using System.Drawing;

namespace Helper
{
    public class Utility
    {
        private static Random rand = new Random();

        public static Color GetRandomColor()
        {
            return Color.FromArgb(rand.Next(256), rand.Next(256), rand.Next(256));
        }

        public static Point GetRandomLocationInParent(Size parentSize, Size childSize)
        {
            int maxX = parentSize.Width - childSize.Width;
            int maxY = parentSize.Height - childSize.Height;

            return new Point
            {
                X = rand.Next(maxX),
                Y = rand.Next(maxY)
            };
        }
    }
}
