﻿using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Zadatak06
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private Random random = new Random();

        public MainWindow()
        {
            InitializeComponent();
        }

        private void AddPanel(object sender, RoutedEventArgs e)
        {
            StackPanel panel = new StackPanel
            {
                Width = 20,
                Height = 20,
                Margin = new Thickness(3),
                Background = GetRandomBrush(),
                LayoutTransform = GetRandomRotate()
            };

            pnlContainer.Children.Add(panel);
        }

        private Transform GetRandomRotate()
        {
            return new RotateTransform(random.Next(360));
        }

        private Brush GetRandomBrush()
        {
            Color color = Color.FromRgb((byte)random.Next(256), (byte)random.Next(256), 
                (byte)random.Next(256));
            return new SolidColorBrush(color);
        }

        private void RemovePanels(object sender, RoutedEventArgs e)
        {
            pnlContainer.Children.Clear();
        }
    }
}