using Utilities;

namespace Task02
{
    public partial class Form1 : Form
    {
        private Size panelSize = new Size(40, 40);
        private Panel lastSelectedPanel = null;
        public Form1()
        {
            InitializeComponent();
            ContextMenuStrip = cmsForm;
        }

        private void cmsItemAddPanel_Click(object sender, EventArgs e)
        {
            if (sender is ToolStripItem item)
            {
                var panelCount = int.Parse(item.Tag.ToString());
                AddPanels(panelCount);
            }
        }

        private void AddPanels(int panelCount)
        {
            for (int i = 0; i < panelCount; i++)
            {
                Panel panel = new Panel
                {
                    BackColor = Utility.GetRandomColor(),
                    Size = panelSize,
                    Location=Utility.GetRandomLocationInParent(ClientSize,panelSize),
                    ContextMenuStrip=cmsPanel,
                };
                panel.Click += panel_Click;
                this.Controls.Add(panel);
            }

        }

        private void panel_Click(object? sender, EventArgs e)
        {
            if (lastSelectedPanel is not null)
                lastSelectedPanel.BorderStyle = BorderStyle.None;
            if (sender is Panel panel)
            { 
                panel.BorderStyle = BorderStyle.FixedSingle;
                panel.BringToFront();
                lastSelectedPanel = panel;
            }
        }

        private void cmsItemRemove_Click(object sender, EventArgs e)
        { 
            this.Controls.Remove(lastSelectedPanel);
            lastSelectedPanel = null;
        }

        private void removeAllPanels_Click(object sender, EventArgs e)=>this.Controls.Clear();
    }
}
