﻿using System;
using System.Globalization;
using System.Threading;
using System.Windows;

namespace Examples
{
    public partial class LocalizationGlobalizationExample : Window
    {
        public LocalizationGlobalizationExample(string culture)
        {
            // setting the culture must happen before the componets are initialized
            SetCulture(culture);
            InitializeComponent();
            ShowNumbersAndDates();
        }

        private void SetCulture(string culture)
        {
            Thread.CurrentThread.CurrentUICulture = new CultureInfo(culture); // for Resources.resx
            Thread.CurrentThread.CurrentCulture = new CultureInfo(culture); // for Numbers, Dates...
        }

        private void ShowNumbersAndDates()
        {
            double number = 87654321.34567;
            // https://stackoverflow.com/questions/4506323/difference-between-tostringn2-and-tostring0-00
            lblNumber.Content = number.ToString("n2", Thread.CurrentThread.CurrentCulture);
            lblDate.Content = DateTime.Now.ToLongDateString();
        }

    }
}
