using System.Text;
using Utilities;

namespace Task01
{
    public partial class Form1 : Form
    {
        short btnIndex;
        short panelIndex;
        int flp = 200;
        FlowLayoutPanel lastAddedPanel;
        public Form1()
        {
            InitializeComponent();
        }

        private void btnAddPanel_Click(object sender, EventArgs e)
        {
            if (flowLayoutPanel.Controls.Count < 6)
                AddFlowLayoutPanel();
        }

        private void AddFlowLayoutPanel()
        {
            btnIndex = 1;
            lastAddedPanel = new FlowLayoutPanel();
            lastAddedPanel.Size = new Size(flp, flp);
            lastAddedPanel.Name = "FLPanel " + ++panelIndex;
            lastAddedPanel.BackColor = Utility.GetRandomColor();

            //odnosi se na gumbe
            lastAddedPanel.FlowDirection = FlowDirection.TopDown;
            lastAddedPanel.WrapContents = false;
            lastAddedPanel.AutoScroll = true;

            flowLayoutPanel.Controls.Add(lastAddedPanel);
        }

        private void btnAddButton_Click(object sender, EventArgs e)
        {
            if (lastAddedPanel != null)
            {
                AddButton();
                btnIndex++;
            }
        }

        private void AddButton()
        {
            Button btn = new Button();
            btn.Text = $"Button number {btnIndex}";
            btn.Name = "Button " + btnIndex;
            btn.Click += btn_Click;
            lastAddedPanel.Controls.Add(btn);
        }

        private void btn_Click(object? sender, EventArgs e)
        {
            Button btn = (Button)sender;
            FlowLayoutPanel panel = (FlowLayoutPanel)btn.Parent;
            panel.Controls.Remove(btn);
        }

        private void btnControl_Click(object sender, EventArgs e)
        {
            StringBuilder sb = new StringBuilder();
            if (lastAddedPanel != null)
            {
                foreach (FlowLayoutPanel panel in flowLayoutPanel.Controls)
                {
                    sb.Append(panel.Name);
                    sb.Append(Environment.NewLine);

                    foreach (Button button in panel.Controls)
                    {
                        sb.Append("\t");
                        sb.Append(button.Name);
                        sb.Append(Environment.NewLine);
                    }
                }
                MessageBox.Show(sb.ToString());
            }
        }
    }
}
