using Helper;

namespace Zadatak06
{
    public partial class Form1 : Form
    {
        private Size panelSize = new Size(200, 200);
        // nullable Panel
        private Panel? lastAddedPanel;

        public Form1()
        {
            InitializeComponent();
        }

        private void btnAddPanel_Click(object sender, EventArgs e)
        {
            Panel panel = new Panel
            {
                Size = panelSize,
                BackColor = FormHelper.GetRandomColor(),
                Location = FormHelper
                .GetRandomLocationInParent(pnlContainer.Size, panelSize)
            };

            pnlContainer.Controls.Add(panel);
            panel.BringToFront();
            lastAddedPanel = panel;
        }

        private void btnAddButton_Click(object sender, EventArgs e)
        {
            //if (lastAddedPanel == null)
            if (lastAddedPanel is null)
            {
                return;
            }

            Button button = new Button { Text = "Remove" };
            button.Location = FormHelper
                .GetRandomLocationInParent(lastAddedPanel.Size, button.Size);
            button.Click += RemoveButton;

            lastAddedPanel.Controls.Add(button);
            button.BringToFront();
        }

        private void RemoveButton(object? sender, EventArgs e)
        {
            Button? button = sender as Button;
            button?.Parent?.Controls.Remove(button);
        }

        private void btnRemoveAllPanels_Click(object sender, EventArgs e)
        {
            pnlContainer.Controls.Clear();
        }

        private void btnRemoveAllButtons_Click(object sender, EventArgs e)
        {
            foreach (Control control in pnlContainer.Controls)
            {
                if (control is Panel panel)
                {
                    panel.Controls.Clear();
                }
            }
        }
    }
}
