﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Task03
{
    public partial class ProgressBarUC : UserControl
    {
        private Color bojaPozadine;
        public Color BojaPozadine
        {
            get {  return bojaPozadine; } set { bojaPozadine = value; }
        }

        private Color bojaRuba;
        public Color BojaRuba
        {
            get { return bojaRuba; } set {bojaRuba = value; }
        }

        private Font fontPostotka;
        public Font FontPostotka
        {
            get { return fontPostotka; } set { fontPostotka = value; }
        }

        private string formatIspisa;
        public string FormatIspisa
        { get { return formatIspisa; } set { formatIspisa = value; } }

        private double progress;

        public ProgressBarUC()
        {
            InitializeComponent();

            BojaPozadine = Color.Blue;
            BojaRuba = Color.Gray;
            FontPostotka = new Font("Arial", 15);
            FormatIspisa = "{0}%";
            progress = 0.5;
        }

        public void PerformStep()
        {
            progress += 0.01;
            if (progress > 1)
                progress = 0;

            //ponovno vrtanje kontole
            this.Invalidate();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);

            //ruba
            e.Graphics.DrawRectangle(new Pen(bojaRuba),0,0,this.ClientRectangle.Width-1,this.ClientRectangle.Height-1);

            //progress
            Rectangle progresRect= new Rectangle(1,1,(int)(this.ClientSize.Width*progress)-2,this.ClientRectangle.Height-2);
            e.Graphics.FillRectangle(new SolidBrush(bojaPozadine), progresRect);

            //postotak
            string postotak=FormatIspisa.Replace("{0}",((int)(progress*100)).ToString());
            SizeF size = e.Graphics.MeasureString(postotak, FontPostotka);
            int y=((int)(this.ClientSize.Height-size.Height)/2);

            if (ImaMjesta(size, this.ClientSize, progresRect))
            {
                //s desne strane progress bara
                e.Graphics.DrawString(postotak, FontPostotka, new SolidBrush(bojaPozadine), progresRect.Width + 2, y);
            }
            else
            {
                //s unutarnje strane progressbara
                e.Graphics.DrawString(postotak, FontPostotka, new SolidBrush(InvertBoja(bojaPozadine)),
                    progresRect.Width-2-size.Width, y);
            }
        }

        private Color InvertBoja(Color c)
        {
            const int RGBMAX = 255;
            return Color.FromArgb(RGBMAX-c.R, RGBMAX-c.G, RGBMAX-c.B);
        }


        //ProgressBar + string, vidjelti da li je veći ili manji od cijelog konterjnera kontrole
        private bool ImaMjesta(SizeF stringSize, Size clientArea, Rectangle progresRect)
        {
            return progresRect.Width+2+stringSize.Width<clientArea.Width;
        }
    }
}
