﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Task07.Model;

namespace Task07.ViewModel
{
    public class AutomobilView : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler? PropertyChanged;

        private Automobil _automobil;

        public AutomobilView(Automobil automobil)
        {
            _automobil = automobil;
        }

        public Vrsta Vrsta
        {
            get { return _automobil.Vrsta; }
        }

        public string RegistracijskaOznaka
        {
            get { return _automobil.RegistracijskaOznaka; }
            set
            { 
                _automobil.RegistracijskaOznaka = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("RegistracijskaOznaka"));
            }
        }

        public string Boja
        {
            get { return _automobil.Boja; }
            set
            {
                _automobil.Boja = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("Boja"));
            }
        }

        public int GodinaPrveRegistracije
        {
            get { return _automobil.GodinaPrveRegistracije; }
            set
            {
                _automobil.GodinaPrveRegistracije = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("GodinaPrveRegistracije"));
            }
        }
    }
}
