using System.Globalization;

namespace Zadatak09
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ShowValues();

            CultureInfo[] cultures = CultureInfo
                .GetCultures(CultureTypes.AllCultures);
            foreach (CultureInfo culture in cultures)
            {
                ddlCultures.Items.Add(new CultureWrapper(culture));
            }
        }

        private void ShowValues()
        {
            lblDate.Text = DateTime.Now.ToLongDateString();
            lblTime.Text = DateTime.Now.ToLongTimeString();

            // 123.45m => money kao Decimal tip podatka
            // "c" => currency (valuta)
            lblPrice.Text = (123.45m).ToString("c");

            lblAmount.Text = (456.78).ToString();
        }

        private void ddlCultures_SelectedIndexChanged(object sender, EventArgs e)
        {
            CultureWrapper? cultureWrapper = ddlCultures.SelectedItem as CultureWrapper;
            if (cultureWrapper is null)
            {
                return;
            }

            Thread.CurrentThread.CurrentCulture = cultureWrapper.Value;
            ShowValues();
        }
    }
}
