using Helper;

namespace Zadatak02
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void AddPanels(object sender, EventArgs e)
        {
            ToolStripItem? item = sender as ToolStripItem;
            if (item is null) return;

            int panelsCount = int.Parse(item.Tag.ToString());

            for (int i = 0; i < panelsCount; i++)
            {
                CreatePanel();
            }
        }

        private void CreatePanel()
        {
            Panel panel = new Panel
            {
                Size = new Size(40, 40),
                BackColor = FormHelper.GetRandomColor()
            };
            panel.Location = FormHelper
                .GetRandomLocationInParent(pnlContainer.Size, panel.Size);

            panel.MouseDown += StartDragAndDrop;

            pnlContainer.Controls.Add(panel);
        }

        private void StartDragAndDrop(object? sender, MouseEventArgs e)
        {
            Panel? panel = sender as Panel;
            if (panel == null) return;

            Point initPoint = panel.PointToScreen(e.Location);

            panel.DoDragDrop(new DragWrapper
            {
                DragPanel = panel,
                Point = initPoint
            }, DragDropEffects.Move | DragDropEffects.Copy);
        }

        private void RemoveAllPanels(object sender, EventArgs e)
        {
            pnlContainer.Controls.Clear();
        }

        private void Container_DragOver(object sender, DragEventArgs e)
        {
            // lijeva tipka
            if (e.KeyState == 1)
            {
                e.Effect = DragDropEffects.Move;
            }
            // desna tipka
            else if (e.KeyState == 2)
            {
                e.Effect= DragDropEffects.Copy;
            }
        }

        private void Container_DragDrop(object sender, DragEventArgs e)
        {
            DragWrapper? dragWrapper = (DragWrapper)e.Data.GetData(typeof(DragWrapper));
            if (dragWrapper == null || dragWrapper.DragPanel == null) return;

            int deltaX = dragWrapper.Point.X - e.X;
            int deltaY = dragWrapper.Point.Y - e.Y;

            Point newPoint = new Point
            {
                X = dragWrapper.DragPanel.Location.X - deltaX,
                Y = dragWrapper.DragPanel.Location.Y - deltaY
            };

            if (e.Effect == DragDropEffects.Move)
            {
                dragWrapper.DragPanel.Location = newPoint;
            }
            else if (e.Effect == DragDropEffects.Copy)
            {
                CopyPanel(new DragWrapper
                {
                    DragPanel = dragWrapper.DragPanel,
                    Point = newPoint
                });
            }
        }

        private void CopyPanel(DragWrapper dragWrapper)
        {
            if (dragWrapper.DragPanel == null) return;

            Panel copyPanel = new Panel
            {
                Size = dragWrapper.DragPanel.Size,
                BackColor = dragWrapper.DragPanel.BackColor,
                Location = dragWrapper.Point
            };
            copyPanel.MouseDown += StartDragAndDrop;

            pnlContainer.Controls.Add(copyPanel);
        }
    }
}
