﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Zadatak08.Model;

namespace Zadatak08.ViewModel
{
	public class AutomobilView : INotifyPropertyChanged
	{
		public event PropertyChangedEventHandler PropertyChanged;

		private Automobil _automobil;

		public AutomobilView(Automobil automobil)
		{
			_automobil = automobil;
		}

		public Vrsta Vrsta 
		{
			get { return _automobil.Vrsta; }			
		}

		public string RegistarskaOznaka
		{
			get { return _automobil.RegistarskaOznaka; }
			set
			{
				_automobil.RegistarskaOznaka = value;

				if (PropertyChanged != null)
				{
					PropertyChanged(this, new PropertyChangedEventArgs("RegistarskaOznaka"));
				}
			}
		}

		public string Boja
		{
			get { return _automobil.Boja; }
			set
			{
				_automobil.Boja = value;

				if (PropertyChanged != null)
				{
					PropertyChanged(this, new PropertyChangedEventArgs("Boja"));
				}
			}
		}

		public int GodinaPrveRegistracije
		{
			get { return _automobil.GodinaPrveRegistracije; }
			set
			{
				_automobil.GodinaPrveRegistracije = value;

				if (PropertyChanged != null)
				{
					PropertyChanged(this, new PropertyChangedEventArgs("GodinaPrveRegistracije"));
				}
			}
		}
	}
}
