using Helper;

namespace Zadatak02
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void AddPanels(object sender, EventArgs e)
        {
            ToolStripItem? item = sender as ToolStripItem;
            if (item is null) return;

            int panelsCount = int.Parse(item.Tag.ToString());

            for (int i = 0; i < panelsCount; i++)
            {
                CreatePanel();
            }
        }

        private void CreatePanel()
        {
            Panel panel = new Panel
            {
                Size = new Size(40, 40),
                BackColor = Utility.GetRandomColor()
            };
            panel.Location =
                Utility.GetRandomLocationInParent(pnlContainer.Size, panel.Size);

            panel.MouseDown += StartDragAndDrop;

            pnlContainer.Controls.Add(panel);
        }

        private void StartDragAndDrop(object? sender, MouseEventArgs e)
        {
            Panel? panel = sender as Panel;
            if (panel is null) return;

            Point initPoint = panel.PointToScreen(e.Location);

            // lijeva tipka Movea, a desna Kopira
            panel.DoDragDrop(new DragWrapper
            {
                Point = initPoint,
                DragPanel = panel
            }, DragDropEffects.Move | DragDropEffects.Copy);
        }

        private void RemoveAllPanels(object sender, EventArgs e)
        {
            pnlContainer.Controls.Clear();
        }

        private void pnlContainer_DragOver(object sender, DragEventArgs e)
        {
            if (e.KeyState == 1) // lijeva tipka
            {
                e.Effect = DragDropEffects.Move;
            }
            else if (e.KeyState == 2) // desna tipka
            {
                e.Effect = DragDropEffects.Copy;
            }
        }

        private void pnlContainer_DragDrop(object sender, DragEventArgs e)
        {
            DragWrapper? dragWrapper = (DragWrapper)e.Data.GetData(typeof(DragWrapper));
            if (dragWrapper is null || dragWrapper.DragPanel is null) return;

            int deltaX = dragWrapper.Point.X - e.X;
            int deltaY = dragWrapper.Point.Y - e.Y;

            Point newPoint = new Point
            {
                X = dragWrapper.DragPanel.Location.X - deltaX,
                Y = dragWrapper.DragPanel.Location.Y - deltaY
            };

            if (e.Effect == DragDropEffects.Move)
            {
                dragWrapper.DragPanel.Location = newPoint;
            }
            else if (e.Effect == DragDropEffects.Copy)
            {
                CopyPanel(new DragWrapper
                {
                    DragPanel = dragWrapper.DragPanel,
                    Point = newPoint
                });
            }
        }

        private void CopyPanel(DragWrapper dragWrapper)
        {
            if (dragWrapper.DragPanel is null) return;

            Panel copyPanel = new Panel
            {
                Size = dragWrapper.DragPanel.Size,
                BackColor = dragWrapper.DragPanel.BackColor,
                Location = dragWrapper.Point
            };
            copyPanel.MouseDown += StartDragAndDrop;

            pnlContainer.Controls.Add(copyPanel);
        }
    }
}
