﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Utility;

namespace ContainerControlsOther
{
    public partial class FlowLayoutPanel : Form
    {
        private bool setFlowBreak = false;

        public FlowLayoutPanel()
        {
            InitializeComponent();
        }

        private void btnAddPanel_Click(object sender, EventArgs e)
        {
            Panel panel = new Panel
            {
                Size = new Size(100, 100),
                BackColor = Helper.GetRandomColor()
            };

            pnlKontejner.SetFlowBreak(panel, setFlowBreak);
            pnlKontejner.Controls.Add(panel);
        }

        private void btnFlowLayoutDirection_Click(object sender, EventArgs e)
        {
            if (pnlKontejner.FlowDirection == FlowDirection.LeftToRight)
            {
                pnlKontejner.FlowDirection = FlowDirection.TopDown;
                btnFlowLayoutDirection.Text = "Left to Right";
            }
            else
            {
                pnlKontejner.FlowDirection = FlowDirection.LeftToRight;
                btnFlowLayoutDirection.Text = "Top Down";
            }
        }

        private void btnSetFlowBreak_Click(object sender, EventArgs e)
        {
            setFlowBreak = !setFlowBreak;

            if (setFlowBreak)
            {
                btnSetFlowBreak.Text = "Unset Flow Break";
            }
            else
            {
                btnSetFlowBreak.Text = "Set Flow Break";
            }
        }
    }
}
