using Common;
using System.Collections;

namespace Zadatak01
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            PlayersService service = new PlayersService();

            try
            {
                List<Player> players = service.GetPlayers();
                foreach (Player player in players)
                {
                    lbSubstitutes.Items.Add(player);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btnSelectedPlayersToSubstitutes_Click(object sender, EventArgs e)
        {
            MovePlayers(lbPlayers, lbSubstitutes, lbPlayers.SelectedItems);
        }

        private void btnAllPlayersToSubstitutes_Click(object sender, EventArgs e)
        {
            MovePlayers(lbPlayers, lbSubstitutes, lbPlayers.Items);
        }

        private void btnSelectedSubstitutesToPlayers_Click(object sender, EventArgs e)
        {
            MovePlayers(lbSubstitutes, lbPlayers, lbSubstitutes.SelectedItems);
        }

        private void btnAllSubstitutesToPlayers_Click(object sender, EventArgs e)
        {
            MovePlayers(lbSubstitutes, lbPlayers, lbSubstitutes.Items);
        }

        private void MovePlayers(ListBox fromListBox, ListBox toListBox,
            IEnumerable selectedItems)
        {
            // 1. kopija liste Players
            List<Player> players = new List<Player>();
            foreach (Player player in selectedItems)
            {
                players.Add(player);
            }

            // 2. prolazak po kopiji kako bi mogli obrisati original
            foreach (Player player in players)
            {
                toListBox.Items.Add(player);
                fromListBox.Items.Remove(player);
            }
        }

        private void cbSorted_CheckedChanged(object sender, EventArgs e)
        {
            //lbPlayers.Sorted = cbSorted.Checked;
            //lbSubstitutes.Sorted = cbSorted.Checked;
            lbPlayers.Sorted = lbSubstitutes.Sorted = cbSorted.Checked;
        }
    }
}
