﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace KorisnickeKontrole
{
    /// <summary>
    /// Interaction logic for ProgressKontrola.xaml
    /// </summary>
    public partial class ProgressKontrola : UserControl
    {
        public double Postotak
        {
            get => pregressBar.Value;
            set
            {
                if (value < 0 || value > 100)
                    return;
                pregressBar.Value = value;
                lblPostotak.Content = $"{value}%";
            }
        }
        public ProgressKontrola()
        {
            InitializeComponent();
        }

        private void UserControl_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            Povecaj();
        }

        private void Povecaj()
        {
            Postotak += 5;
        }

        private void UserControl_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {
            Umanji();
        }

        private void Umanji()
        {
            Postotak -= 5;
        }
    }
}
