using System.Drawing.Printing;
using System.Globalization;

namespace DodatniZadatak
{
    public partial class Form1 : Form
    {
        private const string HR = "hr", EN = "en";

        public Form1()
        {
            //Thread.CurrentThread.CurrentUICulture = new CultureInfo("hr");
            InitializeComponent();
        }

        private void btnChangeCulture_Click(object sender, EventArgs e)
        {
            if (Thread.CurrentThread.CurrentUICulture.Name == HR)
            {
                SetCulture(EN);
            }
            else
            {
                SetCulture(HR);
            }
        }

        private void SetCulture(string lang)
        {
            Thread.CurrentThread.CurrentUICulture = new CultureInfo(lang);
            UpdateUI();
        }

        private void UpdateUI()
        {
            this.Controls.Clear();
            InitializeComponent();
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            printPreviewDialog.ShowDialog();
        }

        private void printDocument_PrintPage(object sender, PrintPageEventArgs e)
        {
            Bitmap bitmap = new Bitmap(this.Width, this.Height);
            Rectangle rectangle = new Rectangle
            {
                X = 0,
                Y = 0,
                Width = bitmap.Width,
                Height = bitmap.Height
            };

            this.DrawToBitmap(bitmap, rectangle);

            e.Graphics?.DrawImage(bitmap, e.MarginBounds.X, e.MarginBounds.Y);
        }

        private void printDocument_EndPrint(object sender, PrintEventArgs e)
        {
            MessageBox.Show(Resources.MyStrings.printFinish);
        }
    }
}
