using System.Drawing.Printing;

namespace Zadatak01_05
{
    public partial class Form1 : Form
    {
        private int printedPagesCount = 0;

        public Form1()
        {
            InitializeComponent();
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            printDialog.ShowDialog();
        }

        private void btnSelectMargins_Click(object sender, EventArgs e)
        {
            pageSetupDialog.ShowDialog();
        }

        private void btnPreview_Click(object sender, EventArgs e)
        {
            printPreviewDialog.ShowDialog();
        }

        private void printDocument_PrintPage(object sender, PrintPageEventArgs e)
        {
            Font font = new Font("Arial", 25, FontStyle.Regular, GraphicsUnit.Pixel);
            e.Graphics?.DrawString("Dobar dan", font, Brushes.Green,
                new PointF(e.MarginBounds.X, e.MarginBounds.Y));

            if (++printedPagesCount < nudCopiesCount.Value)
            {
                e.HasMorePages = true;
            }
            else
            {
                // resetiranje countera
                printedPagesCount = 0;
            }
        }

        private void printDocument_EndPrint(object sender, PrintEventArgs e)
        {
            if (e.PrintAction == PrintAction.PrintToPreview)
            {
                MessageBox.Show("Preview finished!");
            }
        }
    }
}
