using Common;
using System.Collections;

namespace Task01
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            PayersService service = new();

            try
            {
                List<Player> players = service.GetPalyers();
                foreach (Player p in players)
                {
                    lbPlayersBench.Items.Add(p);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void btnOneToBench_Click(object sender, EventArgs e)
        {
            MovePlayers(lbPlayersPlaying, lbPlayersBench, lbPlayersPlaying.SelectedItems);
        }

        private void btnAllToBench_Click(object sender, EventArgs e)
        {
            MovePlayers(lbPlayersPlaying, lbPlayersBench, lbPlayersPlaying.Items);
        }

        private void btnAllToGame_Click(object sender, EventArgs e)
        {
            MovePlayers(lbPlayersBench, lbPlayersPlaying, lbPlayersBench.Items);
        }

        private void btnOneToPlay_Click(object sender, EventArgs e)
        {
            MovePlayers(lbPlayersBench, lbPlayersPlaying, lbPlayersBench.SelectedItems);
        }

        private void MovePlayers(ListBox fromList, ListBox toList, IEnumerable selectedItems)
        {
            List<Player> players = new();

            foreach (Player p in selectedItems)
            {
                players.Add(p);
            }

            //ovo ne radi ako se koristi DataSource
            foreach (Player p in players)
            {
                toList.Items.Add(p);
                fromList.Items.Remove(p);
            }
        }

        private void cbSort_CheckedChanged(object sender, EventArgs e)
        {
            lbPlayersBench.Sorted=lbPlayersPlaying.Sorted=cbSort.Checked;
        }
    }
}
