﻿using System.Windows;
using System.Windows.Controls;

namespace Examples
{
    public partial class ComboBoxExample : Window
    {
        public ComboBoxExample()
        {
            InitializeComponent();
        }

        private void CbCities_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            var cb = e.Source as ComboBox;
            if (cb.SelectedItem != null)
            {
                var cbItem = cb.SelectedItem as ComboBoxItem;
                var stackPanel = cbItem.Content as StackPanel;
                var selectedCity = GetElement<TextBlock>(stackPanel.Children).Text;
                MessageBox.Show(selectedCity);
            }
        }


        private T GetElement<T>(UIElementCollection parent)
        {
            foreach (var item in parent)
            {
                if (item is T t)
                {
                    return t;
                }
            }
            return default;
        }
    }
}
