﻿using System.Collections.Generic;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Shapes;

namespace Examples
{
    public partial class CanvasExample : Window
    {
        readonly List<Point> pointCollection = new();
        public CanvasExample()
        {
            InitializeComponent();
        }

        private void Canvas_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            Point clickPoint = e.GetPosition(Canvas);

            pointCollection.Add(clickPoint);

            Label lbl = new()
            {
                Content = "o"
            };

            lbl.SetValue(Canvas.LeftProperty, clickPoint.X - SystemParameters.CursorWidth / 3);
            lbl.SetValue(Canvas.TopProperty, clickPoint.Y - SystemParameters.CursorHeight / 2);
            Canvas.Children.Add(lbl);

            DrawLines();
        }


        private void DrawLines()
        {
            for (int i = 0; i < pointCollection.Count - 1; i++)
            {

                Canvas.Children.Add(new Line
                {
                    Stroke = Brushes.Black,
                    StrokeThickness = 2,

                    X1 = pointCollection[i].X,
                    Y1 = pointCollection[i].Y,

                    X2 = pointCollection[i + 1].X,
                    Y2 = pointCollection[i + 1].Y
                });
            }
        }

        private void MenuItem_Click(object sender, RoutedEventArgs e)
        {
            Canvas.Children.Clear();
            pointCollection.Clear();
        }
    }
}
