﻿using System.Diagnostics;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Shapes;

namespace Examples
{
    public partial class RoutedEventsExample : Window
    {
        public RoutedEventsExample()
        {
            InitializeComponent();

            //  BUBBLING
            this.MouseDown += On_MouseDown;
            Border.MouseDown += On_MouseDown;
            Grid.MouseDown += On_MouseDown;
            Rectangle.MouseDown += On_MouseDown;

            //  TUNNELING
            this.PreviewMouseDown += On_PreviewMouseDown;
            Border.PreviewMouseDown += On_PreviewMouseDown;
            Grid.PreviewMouseDown += On_PreviewMouseDown;
            Rectangle.PreviewMouseDown += On_PreviewMouseDown;

            //  DIRECT
            this.MouseEnter += On_MouseEnter;
            Border.MouseEnter += On_MouseEnter;
            Grid.MouseEnter += On_MouseEnter;
            Rectangle.MouseEnter += On_MouseEnter;

        }

        private void On_MouseEnter(object sender, MouseEventArgs e)
        {
            Debug.WriteLine($"[DIRECT] On_MouseEnter - {sender}");
        }

        private void On_PreviewMouseDown(object sender, MouseButtonEventArgs e)
        {
            Debug.WriteLine($"[TUNNELING] On_PreviewMouseDown - {sender}");
        }

        private void On_MouseDown(object sender, MouseButtonEventArgs e)
        {
            Debug.WriteLine($"[BUBBLING] On_MouseDown - {sender}");
            if (sender is Grid)
            {
                e.Handled = true;
                Debug.WriteLine($"[BUBBLING-ABORT] On_MouseDown - {sender}");
            }
        }
    }
}
