﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Zadatak07.Models;

namespace Zadatak07.ViewModels
{
    public class CarViewModel : INotifyPropertyChanged
    {
        private Car car;

        public CarViewModel(Car car)
        {
            this.car = car;
        }

        public CarType Type { get => car.Type; }
        public string LicensePlates
        {
            get => car.LicensePlates;
            set
            {
                car.LicensePlates = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(nameof(LicensePlates)));
            }
        }
        public string Color
        {
            get => car.Color;
            set
            {
                car.Color = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(nameof(Color)));
            }
        }
        public int YearFirstRegistration
        {
            get => car.YearFirstRegistration;
            set
            {
                car.YearFirstRegistration = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(nameof(Color)));
            }
        }

        public event PropertyChangedEventHandler? PropertyChanged;

        public override string ToString()
        {
            return $"{Type.Name} - {LicensePlates}, {Color}, {YearFirstRegistration}";
        }
    }
}
