namespace Task03
{
    public partial class Form1 : Form
    {
        private Random random = new Random();
        public Form1()
        {
            InitializeComponent();
        }

        private void btnChange_Click(object sender, EventArgs e)
        {
            this.Size = GetRandomSize();
            this.BackColor = GetRandomColor();

            CenterButton();
        }

        private Color GetRandomColor()
        {
            return Color.FromArgb(random.Next(256), random.Next(256), random.Next(256));
        }

        private Size GetRandomSize()
        {
            int minWidth = 100;
            int maxWidth = 1000;
            int minHeight = 100;
            int maxHeight = 1000;
            return new Size
            {
                Width = random.Next(minWidth, maxWidth),
                Height = random.Next(minHeight, maxHeight)
            };
        }

        private void CenterButton()
        {
            int formWidth = this.ClientSize.Width;
            int formHeight = this.ClientSize.Height;

            int buttonWidth = btnChange.Width;
            int buttonHeight = btnChange.Height;

            int x = (formWidth - buttonWidth) / 2;
            int y = (formHeight - buttonHeight) / 2;

            btnChange.Location = new Point(x, y);
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            CenterButton();
        }
    }
}
