﻿using Examples.Model;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Examples.ViewModel
{
    class StudentViewModel : INotifyPropertyChanged
    {
        private Student student;

        public StudentViewModel(Student student)
        {
            this.student = student;
        }

        public string FirstName
        {
            get
            {
                return student.FirstName;
            }
            set
            {
                student.FirstName = value;
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(student.FirstName)));
            }
        }

        public string LastName
        {
            get
            {
                return student.LastName;
            }
            set
            {
                student.LastName = value;
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(student.LastName)));
            }
        }

        public int Age
        {
            get
            {
                return student.Age;
            }
            set
            {
                student.Age = value;
                PropertyChanged(this, new PropertyChangedEventArgs(nameof(student.Age)));
            }
        }

        public override string ToString() => $"{FirstName} {LastName}, {Age}";
        
        public event PropertyChangedEventHandler PropertyChanged;
    }
}
