using Helper;

namespace Zadatak02
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void AddPanels(object sender, EventArgs e)
        {
            ToolStripItem? item = sender as ToolStripItem;
            if (item is null) return;

            int panelsCount = int.Parse(item.Tag.ToString());

            for (int i = 0; i < panelsCount; i++)
            {
                CreatePanel();
            }
        }

        private void CreatePanel()
        {
            Panel panel = new Panel
            {
                Size = new Size(40, 40),
                BackColor = FormHelper.GetRandomColor(),
                ContextMenuStrip = cmsPanel
            };
            panel.Location = FormHelper
                .GetRandomLocationInParent(pnlContainer.Size, panel.Size);

            pnlContainer.Controls.Add(panel);
        }

        private void RemoveAllPanels(object sender, EventArgs e)
        {
            pnlContainer.Controls.Clear();
        }

        private void RemoveSelectedPanel(object sender, EventArgs e)
        {
            Panel? panel = cmsPanel.SourceControl as Panel;
            
            if (panel is not null)
            {
                pnlContainer.Controls.Remove(panel);
            }
        }
    }
}
