﻿using System.Linq;
using System.Windows;
using System.Windows.Input;

namespace Examples
{
    /// <summary>
    /// Interaction logic for MenuExample.xaml
    /// </summary>
    public partial class MenuExample : Window
    {
        public MenuExample()
        {
            InitializeComponent();
            SetProgress();
        }

        private void TextBox_KeyUp(object sender, KeyEventArgs e)
        {
            SetProgress();
        }

        private void SetProgress()
        {
            var percent = ((TxtMenu.Text.Count() / 100.0) * 100);
            LblProgress.Content = $"Progress: {percent}%";
            Progress.Value = TxtMenu.Text.Count();
        }

        private void MenuItem_Click(object sender, RoutedEventArgs e)
        {
            TxtMenu.Text = string.Empty;
            LblProgress.Content = "Progress: 0%";
            Progress.Value = 0;

        }
    }
}
