﻿using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Task07
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private Random rnd = new();
        public MainWindow()
        {
            InitializeComponent();
            mojGrid.Background = GetRandomLinearGradientColor();
        }

        private Brush GetRandomLinearGradientColor()
        {
            LinearGradientBrush lgb=new LinearGradientBrush();

            GradientStop stop1= new GradientStop();
            stop1.Color = GetRandomColor();
            stop1.Offset = 0;

            GradientStop stop2= new GradientStop();
            stop2.Color = GetRandomColor();
            stop2.Offset = 1;

            lgb.GradientStops.Add(stop1);
            lgb.GradientStops.Add(stop2);
            return lgb;
        }

        private Color GetRandomColor()
        {
            var r=(byte)rnd.Next(256);
            var g = (byte)rnd.Next(256);
            var b = (byte)rnd.Next(256);

            return Color.FromArgb(255,r,g,b);
        }

        private void Window_MouseDown(object sender, MouseButtonEventArgs e)
        {
            int brojRedaka = mojGrid.RowDefinitions.Count;
            int brojStupaca=mojGrid.ColumnDefinitions.Count;

            foreach (Button btn in mojGrid.Children)
            { 
                int trenutniRedak=(int)btn.GetValue(Grid.RowProperty);
                int trenutniStupac=(int)btn.GetValue(Grid.ColumnProperty);
                //provjera trenutne pozicije 

                trenutniStupac++;
                if (trenutniStupac >= brojStupaca)
                {
                    trenutniStupac = 0;
                    trenutniRedak++;

                    if (trenutniRedak >= brojRedaka)
                        trenutniRedak = 0;
                }

                btn.SetValue(Grid.RowProperty, trenutniRedak);
                btn.SetValue(Grid.ColumnProperty, trenutniStupac);
            }
            mojGrid.Background = GetRandomLinearGradientColor();
        }
    }
}