namespace Task01
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ShowTime();
            btnCancel.Enabled = false;
        }

        private void ShowTime()
        {
           lblTime.Text=DateTime.Now.ToLongTimeString();
        }

        private void btnCalculate_Click(object sender, EventArgs e)
        {
            long n = long.Parse(txtNumber.Text);
            btnCancel.Enabled = true;
            backgroundWorker.RunWorkerAsync(n);
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            backgroundWorker.CancelAsync();
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            ShowTime();
        }

        private void backgroundWorker_DoWork(object sender, System.ComponentModel.DoWorkEventArgs e)
        {
            if (e.Argument is null) return;
            long n =(long)e.Argument;
            long sum = 0;
            int previusPercentage = 0;

            for (long i = 1; i <= n; i++)
            {
                if (backgroundWorker.CancellationPending)
                { 
                    e.Cancel = true;
                    return;
                }

                int percentage = (int)((double)i / n * 100);
                if(percentage != previusPercentage) 
                    backgroundWorker.ReportProgress(percentage);
                previusPercentage = percentage;

                sum += i;
            }
            e.Result = sum;
        }

        private void backgroundWorker_ProgressChanged(object sender, System.ComponentModel.ProgressChangedEventArgs e)
        {
            progressBar.Value= e.ProgressPercentage;
        }

        private void backgroundWorker_RunWorkerCompleted(object sender, System.ComponentModel.RunWorkerCompletedEventArgs e)
        {
            btnCancel.Enabled = false;
            if (e.Cancelled)
            {
                lblResult.Text = "Canceled!";
                return;
            }
            if(e.Result is not null)
                lblResult.Text=((long)e.Result).ToString("#,###"); //separtator za tisuu u metodi ToString()
        }
    }
}
