﻿using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Zadatak03
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private List<Point> points = new List<Point>();

        public MainWindow()
        {
            InitializeComponent();
        }

        private void myCanvas_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            Point leftClickPoint = e.GetPosition(myCanvas);
            points.Add(leftClickPoint);
            if (points.Count > 1)
            {
                DrawLine();
            }
        }

        private void DrawLine()
        {
            Line line = new Line
            {
                Stroke = this.FindResource("myBrush") as Brush,
                StrokeThickness = 2,
                X1 = points[points.Count - 2].X,
                Y1 = points[points.Count - 2].Y,
                X2 = points[points.Count - 1].X,
                Y2 = points[points.Count - 1].Y
            };

            myCanvas.Children.Add(line);
        }

        private void myCanvas_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {
            Point rightClickPoint = e.GetPosition(myCanvas);

            Label label = new Label { Content = "x" };
            label.SetValue(Canvas.LeftProperty, rightClickPoint.X);
            label.SetValue(Canvas.TopProperty, rightClickPoint.Y);

            myCanvas.Children.Add(label);
        }
    }
}