﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace UserControlsCulturePrint
{
    public partial class AddUpdateUserForm : Form
    {
        public AddUpdateUserForm()
        {
            InitializeComponent();
            this.Text = Properties.Resources.adding;
        }

        public AddUpdateUserForm(User user)
        {
            InitializeComponent();
            this.Text = Properties.Resources.updating;
            SetData(user);
        }

        private void SetData(User user)
        {
            txtFirstName.Text = user.FirstName;
            txtLastName.Text = user.LastName;
        }

        private void TxtFirstName_Validating(object sender, CancelEventArgs e)
        {
            HandleValidation(txtFirstName, e, Properties.Resources.firstNameError);
        }

        private void TxtLastName_Validating(object sender, CancelEventArgs e)
        {
            HandleValidation(txtLastName, e, Properties.Resources.lastNameError);
        }

        private void HandleValidation(TextBox textBox, CancelEventArgs e, string errorMessage)
        {
            if (string.IsNullOrWhiteSpace(textBox.Text))
            {
                e.Cancel = true;
                errorProvider.SetError(textBox, errorMessage);
            }
            else
            {
                e.Cancel = false;
                errorProvider.SetError(textBox, string.Empty);
            }
        }

        public User GetUser()
        {
            return new User
            {
                FirstName = txtFirstName.Text,
                LastName = txtLastName.Text
            };
        }
    }
}
