using System.Drawing.Printing;
using System.Globalization;

namespace TaskDodatni
{
    public partial class Form1 : Form
    {
        private const string HR = "hr", EN = "en";
        public Form1()
        {
            InitializeComponent();
        }

        private void btnChange_Click(object sender, EventArgs e)
        {
            if (Thread.CurrentThread.CurrentCulture.Name == HR)
                SetCulture(EN);
            else SetCulture(HR);
            ShowDateTime();
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            printPreviewDialog.ShowDialog();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            SetCulture(HR);
            ShowDateTime();
        }

        private void ShowDateTime()
        {
            lblDate.Text = DateTime.Now.ToLongDateString();
            lblTime.Text = DateTime.Now.ToLongTimeString();
        }

        private void SetCulture(string lang)
        {
            var culture = new CultureInfo(lang);
            //globalizacija
            Thread.CurrentThread.CurrentCulture = culture;
            //lokalizacija
            Thread.CurrentThread.CurrentUICulture = culture;
            UpdateUI(culture);
        }

        private void UpdateUI(CultureInfo culture)
        {
            this.Controls.Clear();
            InitializeComponent();
        }

        private void printDocument_EndPrint(object sender, System.Drawing.Printing.PrintEventArgs e)
        {
            if (e.PrintAction == PrintAction.PrintToPreview)
                MessageBox.Show("Finish");
        }

        private void printDocument_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            var x = e.MarginBounds.Left;
            var y = e.MarginBounds.Top;
            var bmp=new Bitmap(this.Size.Width, this.Size.Height);

            //svaka kontrola je definirana metodom DrawToBitmap
            this.DrawToBitmap(bmp, new Rectangle
            {
                X = 0,
                Y = 0,
                Width = this.Size.Width,
                Height = this.Size.Height
            });
            e.Graphics?.DrawImage(bmp, x, y);
        }
    }
}
