using System.Globalization;

namespace Task09
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            foreach(var culture in CultureInfo.GetCultures(CultureTypes.AllCultures).OrderBy(k=>k.Name))
                comboBox1.Items.Add(new Culture(culture.NativeName, culture));
            ShowValues();
        }

        private void ShowValues()
        {
            lblDate.Text=DateTime.Now.ToLongDateString();
            lblTime.Text=DateTime.Now.ToLongTimeString();
            lblPrice.Text = (123.45m).ToString("c"); //c kao "currency"
            lblAmount.Text = (456.78).ToString();
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            var culture=comboBox1.SelectedItem as Culture;
            if (culture is null) return;
            Thread.CurrentThread.CurrentCulture = culture.Value;
            ShowValues();
        }
    }
}
