using System.Drawing.Printing;

namespace Task01_05
{
    public partial class Form1 : Form
    {
        private int printedPages;
        public Form1()
        {
            InitializeComponent();
            printedPages = 0;
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            if (printDialog.ShowDialog() == DialogResult.OK)
                printDocument.Print();
        }

        private void btnMargins_Click(object sender, EventArgs e)
        {
            pageSetupDialog.ShowDialog();
        }

        private void btnPreview_Click(object sender, EventArgs e)
        {
            printPreviewDialog.ShowDialog();
        }

        private void printDocument_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            var font = new Font("Arial", 25, FontStyle.Regular, GraphicsUnit.Pixel);
            e.Graphics?.DrawString("Dobar dan!", font, Brushes.Green, new Point(e.MarginBounds.X, e.MarginBounds.Y));

            if (++printedPages < nudCopiesCount.Value)
                e.HasMorePages = true;
            else printedPages = 0;
        }

        private void printDocument_EndPrint(object sender, System.Drawing.Printing.PrintEventArgs e)
        {
            if (e.PrintAction == PrintAction.PrintToPrinter)
                MessageBox.Show("Printinf finished!");
        }
    }
}
