using System.Drawing.Printing;

namespace Task1_5
{
    public partial class Form1 : Form
    {
        private int printedPageCount = 0;
        public Form1()
        {
            InitializeComponent();
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            printDialog.ShowDialog();
        }

        private void btnMargins_Click(object sender, EventArgs e)
        {
            pageSetupDialog.ShowDialog();
        }

        private void btnPreview_Click(object sender, EventArgs e)
        {
            printPreviewDialog.ShowDialog();
        }

        private void printDocument_PrintPage(object sender, PrintPageEventArgs e)
        {
            Font font = new Font("Arial", 25, FontStyle.Regular, GraphicsUnit.Pixel);
            e.Graphics?.DrawString("Dobar dan!", font, Brushes.Green,
                new PointF(e.MarginBounds.X, e.MarginBounds.Y));

            if (++printedPageCount < nudCopiesCount.Value)
                e.HasMorePages = true;
            else
                printedPageCount = 0; // reset countera za sljedei ipis
        }

        private void printDocument_EndPrint(object sender, PrintEventArgs e)
        {
            if (e.PrintAction == PrintAction.PrintToPreview)
                MessageBox.Show("Printing To Preview");
        }
    }
}
