using System.Globalization;

namespace Zadatak08
{
    public partial class Form1 : Form
    {
        private const string HR = "hr", EN = "en";

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            SetCulture(HR);
            ShowDateTime();
        }

        private void SetCulture(string lang)
        {
            CultureInfo culture = new CultureInfo(lang);

            // postavljanje globalizacije (jezik, vrijeme, ...)
            Thread.CurrentThread.CurrentCulture = culture;

            // postavljanje lokalizacije (prijevodi)
            Thread.CurrentThread.CurrentUICulture = culture;
        }

        private void ShowDateTime()
        {
            lblTime.Text = DateTime.Now.ToLongTimeString();
            lblDate.Text = DateTime.Now.ToLongDateString();
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            ShowDateTime();
        }

        private void btnChangeCulture_Click(object sender, EventArgs e)
        {
            if (Thread.CurrentThread.CurrentCulture.Name == HR)
            {
                SetCulture(EN);
            }
            else
            {
                SetCulture(HR);
            }

            ShowDateTime();
        }
    }
}
