﻿using System.ComponentModel;
using Zadatak07.Models;

namespace Zadatak07.ViewModels
{
    public class CarViewModel : INotifyPropertyChanged
    {
        private Car car;

        public CarViewModel(Car car)
        {
            this.car = car;
        }

        public Models.Type Type { get => car.Type; }
        public string LicensePlates
        {
            get => car.LicensePlates;
            set
            {
                car.LicensePlates = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(nameof(LicensePlates)));
            }
        }
        public string Color
        {
            get => car.Color;
            set
            {
                car.Color = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(nameof(Color)));
            }
        }
        public int FirstYearOfRegistration
        {
            get => car.FirstYearOfRegistration;
            set
            {
                car.FirstYearOfRegistration = value;
                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(nameof(FirstYearOfRegistration)));
            }
        }

        public event PropertyChangedEventHandler? PropertyChanged;

        public override string ToString()
        {
            return $"{Type.Name} - {LicensePlates}, {Color}, {FirstYearOfRegistration}";
        }
    }
}
