using System.Globalization;

namespace Task08
{
    public partial class Form1 : Form
    {
        private const string EN = "en";
        private const string HR = "hr";
        public Form1()
        {
            SetCulture(HR);
            InitializeComponent();
        }

        private void SetCulture(string lang)
        {
            CultureInfo culture = new CultureInfo(lang);

            //globalizacija
            Thread.CurrentThread.CurrentCulture = culture;

            //lokalizacija
            Thread.CurrentThread.CurrentUICulture = culture;
            UpdateUI();
        }

        private void UpdateUI()
        {
            this.Controls.Clear();
            InitializeComponent();
        }

        private void btnChange_Click(object sender, EventArgs e)
        {
            if (Thread.CurrentThread.CurrentCulture.Name == HR)
                SetCulture(EN);
            else
                SetCulture(HR);
            ShowDateTime();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ShowDateTime();

        }

        private void ShowDateTime()
        {
            lblTime.Text = DateTime.Now.ToLongTimeString();
            lblDate.Text = DateTime.Now.ToLongDateString();
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            ShowDateTime();
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            printPreviewDialog.ShowDialog();
        }

        private void printDocument_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            Bitmap bitmap=new Bitmap(this.Width, this.Height);
            this.DrawToBitmap(bitmap, new Rectangle
            {
                X = 0,
                Y = 0,
                Width = this.Width,
                Height = this.Height
            });
            e.Graphics?.DrawImage(bitmap, e.MarginBounds.X, e.MarginBounds.Y);
        }

        private void printDocument_EndPrint(object sender, System.Drawing.Printing.PrintEventArgs e)
        {
            MessageBox.Show("Print finished!");
        }
    }
}
