﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Task02
{
    public partial class AnalogClock : UserControl
    {
        private System.Windows.Forms.Timer timer;

        public bool ShowSeconds {  get; set; }

        private Pen hourPen;
        private Pen handsPen;

        private Color clockColor;
        public Color ClockColor
        { 
            get { return clockColor; }
            set {clockColor = value; hourPen = new Pen(clockColor, 2f); }
        }

        private Color handsColor;
        public Color HandsColor
        {
            get { return handsColor; }
            set { handsColor = value; handsPen=new Pen(handsColor,4f); }
        }

        public AnalogClock()
        {
            InitializeComponent();

            ShowSeconds = true;
            ClockColor = Color.Blue;
            HandsColor = Color.Red;

            timer = new();
            timer.Interval = 1000;
            timer.Tick += timer_Tick;
            timer.Start();
        }

        private void timer_Tick(object? sender, EventArgs e)
        {
            //ponovno crtanje kontrole
            this.Invalidate();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);

            Point centar=new Point(this.ClientSize.Width/2, this.ClientSize.Height/2);

            //sat
            e.Graphics.DrawEllipse(hourPen, 0,0,this.ClientSize.Width-1,this.ClientSize.Height-1);

            DateTime currentTime= DateTime.Now;

            //duljina kazaljki na satu
            int handLength = this.ClientSize.Width / 2 - 40;

            int x1=centar.X;
            int y1=centar.Y;

            //sati
            double hourAngle = (currentTime.Hour / 12.0) * (2 * Math.PI);
            int x2Hour=centar.X+(int)(handLength*Math.Sin(hourAngle));
            int y2Hour=centar.Y-(int)(handLength*Math.Cos(hourAngle));
            e.Graphics.DrawLine(handsPen,x1,y1,x2Hour,y2Hour);

            //Minute
            handLength = handLength + 30;
            double minuteAngle= (currentTime.Minute /60.0)*(2 * Math.PI);
            int x2Min= centar.X + (int)(handLength * Math.Sin(hourAngle));
            int y2Min= centar.Y - (int)(handLength * Math.Cos(hourAngle));
            e.Graphics.DrawLine(handsPen, x1,y1,x2Min,y2Min);

            if (ShowSeconds)
            { 
                //Sekunde
                handLength = handLength + 10;
                double secondAngle=(currentTime.Second /60.0)*(2 * Math.PI);
                int x2Sec=centar.X + (int)(handLength*(Math.Sin(secondAngle)));
                int y2Sec=centar.Y - (int)(handLength*Math.Cos(secondAngle));
                e.Graphics.DrawLine(handsPen,x1,y1, x2Sec,y2Sec);
            }

            //krug u sredini sata
            e.Graphics.FillEllipse(new SolidBrush(clockColor),centar.X-10, centar.Y-10,20,20);
        }
    }
}
