﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Task08.Model;

namespace Task08.ViewModel
{
    public class AutoVM : INotifyPropertyChanged
    {
        public event PropertyChangedEventHandler? PropertyChanged;

        private Auto _auto;

        public AutoVM(Auto auto)
        {
            _auto = auto;
        }

        public Vrsta Vrsta { get { return _auto.Vrsta; } }

        public string RegistracijskaOznaka
        {
            get { return _auto.RegistracijskaOznaka; }
            set
            { 
                _auto.RegistracijskaOznaka= value;
                if (PropertyChanged != null)
                    PropertyChanged(this, new PropertyChangedEventArgs("RegistracijskaOznaka"));
            }
        }

        public string Boja
        {
            get { return _auto.Boja; }
            set
            {
                _auto.Boja = value;
                if (PropertyChanged != null)
                    PropertyChanged(this, new PropertyChangedEventArgs("Boja"));
            }
        }

        public int GodinaPrveRegistracije
        {
            get { return _auto.GodinaPrveRegistracije; }
            set
            {
                _auto.GodinaPrveRegistracije = value;
                if (PropertyChanged != null)
                    PropertyChanged(this, new PropertyChangedEventArgs("GodinaPrveRegistracije"));
            }
        }
    }
}
