using Helper;
using System.Text;

namespace Zadatak0102
{
    public partial class Form1 : Form
    {
        private Size panelSize = new Size(200, 200);
        private int panelIndex = 1;
        private int buttonIndex = 1;

        private Panel? lastAddedPanel;

        public Form1()
        {
            InitializeComponent();
        }

        private void btnAddPanel_Click(object sender, EventArgs e)
        {
            FlowLayoutPanel panel = new FlowLayoutPanel
            {
                Size = panelSize,
                BackColor = FormHelper.GetRandomColor(),
                FlowDirection = FlowDirection.TopDown,
                WrapContents = false,
                AutoScroll = true,
                Name = $"Panel {panelIndex++}"
            };

            pnlContainer.Controls.Add(panel);
            lastAddedPanel = panel;

            // reset countera
            buttonIndex = 1;
        }

        private void btnAddButton_Click(object sender, EventArgs e)
        {
            if (lastAddedPanel is null)
            {
                return;
            }

            Button button = new Button
            {
                Text = "Remove",
                Name = $"Button {buttonIndex++}"
            };
            button.Click += RemoveButton;

            lastAddedPanel.Controls.Add(button);
        }

        private void RemoveButton(object? sender, EventArgs e)
        {
            Button? button = sender as Button;
            button?.Parent?.Controls.Remove(button);
        }

        private void btnControlHierarchy_Click(object sender, EventArgs e)
        {
            StringBuilder sb = new StringBuilder();

            foreach (Control control in pnlContainer.Controls)
            {
                if (control is Panel panel)
                {
                    sb.AppendLine(panel.Name);

                    foreach (Control subcontrol in panel.Controls)
                    {
                        sb.AppendLine($"\t{subcontrol.Name}");
                    }
                }
            }

            MessageBox.Show(sb.ToString(), "Hijerarhija kontrola");
        }
    }
}
