namespace Zadatak01
{
    public partial class Form1 : Form
    {
        private Button initBtnStyle;
        private Button dropBtnStyle;

        public Form1()
        {
            InitializeComponent();

            // uti s crnim fontom
            initBtnStyle = new Button
            {
                BackColor = button2.BackColor,
                ForeColor = button2.ForeColor
            };
            // plavi s bijelim fontom
            dropBtnStyle = new Button
            {
                BackColor = button1.BackColor,
                ForeColor = button1.ForeColor
            };
        }

        private void Button_MouseDown(object sender, MouseEventArgs e)
        {
            StartDragDrop(sender as Button);
        }

        private void StartDragDrop(Button? button)
        {
            // smijemo draggati samo plavi (dropBtnStyle) button
            if (button is null ||
                button.BackColor == initBtnStyle.BackColor)
            {
                return;
            }

            lblInfo.Text = "Started Drag and Drop...";
            button.DoDragDrop(button, DragDropEffects.Move);
        }

        private void Button_DragEnter(object sender, DragEventArgs e)
        {
            Button? yellowBtn = sender as Button;
            if (yellowBtn is null || 
                yellowBtn.BackColor != initBtnStyle.BackColor)
            {
                return;
            }

            lblInfo.Text = "Drop allowed...";
            // Effect se mora poklapati s onim iz DoDragDrop
            e.Effect = DragDropEffects.Move;
        }

        private void Button_DragLeave(object sender, EventArgs e)
        {
            lblInfo.Text = "Drop not allowed...";
        }

        private void Button_DragDrop(object sender, DragEventArgs e)
        {
            Button? yellowBtn = sender as Button;
            if (yellowBtn is null) return;

            Button blueBtn = (Button)e.Data.GetData(typeof(Button));

            yellowBtn.BackColor = blueBtn.BackColor;
            yellowBtn.ForeColor = blueBtn.ForeColor;

            blueBtn.BackColor = initBtnStyle.BackColor;
            blueBtn.ForeColor = initBtnStyle.ForeColor;
        }
    }
}
